#version 330

in vec3 position;
in float particle_size;
in float brightness;
flat in int texture_index;

out float brightness_geom;
out float particle_geom_size;
flat out int texture_index_geom;

uniform mat4 view_to_clip;
uniform mat4 model_to_view;

void main()
{
    brightness_geom = brightness;
    particle_geom_size = particle_size;
    gl_Position = view_to_clip * model_to_view * vec4(position, 1.0f);
    texture_index_geom = texture_index;
}